/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.pt.ptmp.impl;

import com.cisco.pt.LTV;
import com.cisco.pt.impl.IPCErrorLTV;
import com.cisco.pt.impl.IPCEventLTV;
import com.cisco.pt.impl.KeepAliveLTV;
import com.cisco.pt.ptmp.PacketTracerReadWorker;
import com.cisco.pt.ptmp.PacketTracerSession;
import com.cisco.pt.ptmp.Pipeline;
import com.cisco.pt.util.Pair;
import com.cisco.pt.util.Utilities;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Semaphore;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PacketTracerReadWorkerImpl
extends Thread
implements PacketTracerReadWorker {
    protected PacketTracerSession session;
    protected Pipeline pipeline;
    protected Map<Integer, Pair<Semaphore, LTV>> waiters = new ConcurrentHashMap<Integer, Pair<Semaphore, LTV>>();
    protected volatile boolean shouldStop = false;
    private static Log logger = LogFactory.getLog(PacketTracerReadWorkerImpl.class);

    public PacketTracerReadWorkerImpl(PacketTracerSession session, Pipeline pipeline) {
        this.session = session;
        this.pipeline = pipeline;
    }

    public Pipeline getPipeline() {
        return this.pipeline;
    }

    public void registerRequest(LTV ltv) {
        if (!ltv.hasResponse()) {
            throw new Error("Attempt to register an LTV with no response; LTV = " + ltv);
        }
        Pair pair = new Pair();
        Semaphore semaphore = new Semaphore(0, true);
        pair.setFirst(semaphore);
        this.waiters.put(ltv.getMessageId(), pair);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LTV getResponse(LTV ltv) {
        if (!ltv.hasResponse()) {
            throw new Error("Attempt to get a response for an LTV with no response; LTV = " + ltv);
        }
        Pair<Semaphore, LTV> pair = this.waiters.get(ltv.getMessageId());
        if (pair == null) {
            throw new Error("Attempt to get a response for an unregistered LTV; LTV = " + ltv);
        }
        try {
            pair.getFirst().acquire();
            LTV lTV = pair.getSecond();
            return lTV;
        }
        catch (InterruptedException e) {
            logger.error((Object)"Attempt to acquire mutex interrupted", (Throwable)e);
            this.waiters.remove(ltv.getMessageId());
            LTV lTV = null;
            return lTV;
        }
        finally {
            this.waiters.remove(ltv.getMessageId());
        }
    }

    public void shouldStop() {
        this.shouldStop = true;
        this.interrupt();
    }

    public void run() {
        while (!this.shouldStop) {
            try {
                LTV inbound = this.pipeline.read();
                if (inbound == null) {
                    logger.info((Object)"PacketTracerReadWorker: Null inbound LTV; will be ignored.");
                    continue;
                }
                if (inbound.isResponse() || inbound instanceof IPCErrorLTV) {
                    Pair<Semaphore, LTV> waitingPair = this.waiters.get(inbound.getMessageId());
                    if (waitingPair != null) {
                        waitingPair.setSecond(inbound);
                        waitingPair.getFirst().release();
                        continue;
                    }
                    this.discardUnmatchedResponse(inbound);
                    continue;
                }
                if (inbound.isEvent()) {
                    this.session.getEventManager().eventQueue.put((IPCEventLTV)inbound);
                    continue;
                }
                if (inbound.isMuMessage()) {
                    this.session.handleMuMessage(inbound);
                    continue;
                }
                if (inbound instanceof KeepAliveLTV) {
                    this.readKeepAlive(inbound);
                    continue;
                }
                this.discardUnknownMessage(inbound);
            }
            catch (IOException ioe) {
                logger.error((Object)"Error during processing of an inbound LTV", (Throwable)ioe);
                try {
                    for (Pair<Semaphore, LTV> pair : this.waiters.values()) {
                        pair.getFirst().release();
                    }
                }
                catch (Throwable t) {
                    Utilities.check(t);
                    logger.error((Object)("Exception releasing waiters: " + t.getMessage()));
                }
                this.session.readWorkerError(ioe);
            }
            catch (InterruptedException e) {
                this.shouldStop = true;
            }
            catch (Throwable t) {
                Utilities.check(t);
                t.printStackTrace();
                this.session.readWorkerError(t);
            }
        }
    }

    protected void discardUnmatchedResponse(LTV ltv) {
        logger.info((Object)("Response with no pending request received.  ID = " + ltv.getMessageId() + "; LTV = " + ltv));
    }

    protected void discardUnknownMessage(LTV ltv) {
        logger.info((Object)("Unrecognized kind of message read.  ID = " + ltv.getMessageId() + "; Type = " + ltv.getType() + "; LTV = " + ltv));
    }

    protected void readKeepAlive(LTV ltv) {
        this.session.handleKeepAlive(ltv);
    }
}

